/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.api;

import filenet.vw.api.VWArrayHandler;
import filenet.vw.api.VWDataField;
import filenet.vw.api.VWException;
import filenet.vw.api.VWInstructionElement;
import filenet.vw.api.VWParticipant;
import filenet.vw.api.VWProcess;
import filenet.vw.api.VWQuery;
import filenet.vw.api.VWReturnStackElement;
import filenet.vw.api.VWStepElement;
import filenet.vw.api.VWStepProcessorInfo;
import filenet.vw.api.VWWorkElement;
import filenet.vw.server.VWField;
import filenet.vw.server.VWWorkObjectID;
import java.io.Serializable;
import java.util.Date;

public final class VWWorkObject
extends VWWorkElement
implements Serializable {
    private static final long serialVersionUID = 119077L;
    public static final int FIELD_USER_DEFINED = 1;
    public static final int FIELD_SYSTEM_DEFINED = 2;
    public static final int FIELD_USER_AND_SYSTEM_DEFINED = 3;
    private String workFlowId;
    protected static final int FLAG_CAN_ATTACH = 1;
    protected static final int FLAG_CAN_RETURN = 2;
    protected static final int FLAG_CAN_REASSIGN = 4;
    protected static final int FLAG_CAN_VIEW_STATUS = 8;

    public static String _get_FILE_DATE() {
        return "$Date: 2010-02-23 21:57:30 GMT $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author: Kevin Bentley;096657649;kbentley@us.ibm.com (kbentley) $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision: /main/PUI_452_Int/PUI_460_Int/1 $";
    }

    protected VWWorkObject(VWField[] fieldValues, VWWorkObjectID work_object_Id, VWQuery source) {
        super(fieldValues, work_object_Id, source);
    }

    public VWInstructionElement fetchInstructionElement(boolean lock, boolean overrideLock) throws VWException {
        VWInstructionElement resultObject = new VWInstructionElement(null, this.workObjectId, this.sourceQuery);
        resultObject.fetchFields(2, lock, overrideLock);
        if (null == resultObject.workObjectId) {
            return null;
        }
        return resultObject;
    }

    public void refresh(boolean lock, boolean overrideLock) throws VWException {
        this.fetchFields(1, lock, overrideLock);
    }

    public void doRefresh(boolean lock, boolean overrideLock) throws VWException {
        this.fetchFields(1, lock, overrideLock);
    }

    public static VWException[] unlockMany(VWWorkObject[] workObjects, boolean save, boolean dispatch) throws VWException {
        int saveType = save ? 1 : 0;
        return VWWorkObject.unlockSave(workObjects, saveType, false, null, null, null, false, true, dispatch);
    }

    public static VWException[] doUnlockMany(VWWorkObject[] workObjects, boolean save, boolean dispatch) throws VWException {
        int saveType = save ? 1 : 0;
        return VWWorkObject.unlockSave(workObjects, saveType, false, null, null, null, false, true, dispatch);
    }

    public static VWException[] saveMany(VWWorkObject[] workObjects) throws VWException {
        return VWWorkObject.unlockSave(workObjects, 1, false, null, null, null, false, false, false);
    }

    public static VWException[] doSaveMany(VWWorkObject[] workObjects) throws VWException {
        return VWWorkObject.unlockSave(workObjects, 1, false, null, null, null, false, false, false);
    }

    public void unlock(boolean save, boolean dispatch) throws VWException {
        boolean isExceptionMap;
        VWException[] rets = VWWorkObject.unlockSave(new VWWorkObject[]{this}, save ? 1 : 0, false, null, (isExceptionMap = this.getIsExceptionMap()) ? this.getExceptionInstructionSheet() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, true, dispatch);
        if (rets != null && rets[0] instanceof VWException) {
            throw rets[0];
        }
    }

    public void setException(String aInstructionSheetName, String aDescription) throws VWException {
        super.setException(aInstructionSheetName, aDescription);
    }

    public String getExceptionInstructionSheet() {
        return super.getExceptionInstructionSheet();
    }

    public String getExceptionDescription() {
        return super.getExceptionDescription();
    }

    public void save() throws VWException {
        VWException[] rets = VWWorkObject.saveMany(new VWWorkObject[]{this});
        if (rets != null && rets[0] instanceof VWException) {
            throw rets[0];
        }
    }

    public static VWException[] lockMany(VWWorkObject[] wobjs, boolean overrideLock) throws VWException {
        return VWWorkElement.lockMany(wobjs, overrideLock, 1);
    }

    public static VWException[] doLockMany(VWWorkObject[] wobjs, boolean overrideLock) throws VWException {
        return VWWorkElement.lockMany(wobjs, overrideLock, 1);
    }

    public void lock(boolean overrideLock) throws VWException {
        super.lock(overrideLock, 1);
    }

    public void doLock(boolean overrideLock) throws VWException {
        super.lock(overrideLock, 1);
    }

    public static VWException[] terminateMany(VWWorkObject[] elements) throws VWException {
        return VWWorkElement.terminateMany(elements);
    }

    public static VWException[] doTerminateMany(VWWorkObject[] elements) throws VWException {
        return VWWorkElement.terminateMany(elements);
    }

    public void terminate() throws VWException {
        super.terminate();
    }

    public void doTerminate() throws VWException {
        super.terminate();
    }

    public static VWException[] doDeleteMany(VWWorkObject[] elements, boolean overrideLock, boolean force) throws VWException {
        return VWWorkElement.deleteMany(elements, overrideLock, force);
    }

    public void doDelete(boolean overrideLock, boolean force) throws VWException {
        super.delete(overrideLock, force);
    }

    public int fetchLockedStatus() throws VWException {
        return super.fetchLockedStatus();
    }

    public String[] getFieldNames() {
        return super.getFieldNames();
    }

    public String[] getAuthoredFieldNames() {
        return super.getAuthoredFieldNames();
    }

    public Object getFieldValue(String fieldName) throws VWException {
        return super.getFieldValue(fieldName);
    }

    public void setFieldValue(String fieldName, Object fieldValue) throws VWException {
        super.setFieldValue(fieldName, fieldValue, false);
    }

    public void setFieldValue(String fieldName, Object fieldValue, boolean compareValue) throws VWException {
        super.setFieldValue(fieldName, fieldValue, compareValue);
    }

    public boolean hasFieldName(String fieldName) throws VWException {
        return super.hasFieldName(fieldName);
    }

    public boolean getIsAltered() {
        return super.getIsAltered();
    }

    protected boolean getCanReturnToSource() throws VWException {
        int flag = super.getUIFlag();
        return (flag & 2) == 2;
    }

    public boolean hasBeenAltered(String fieldName) throws VWException {
        return super.hasBeenAltered(fieldName);
    }

    public String getWorkObjectName() throws VWException {
        return super.getWorkObjectName();
    }

    public String getWorkObjectNumber() throws VWException {
        return super.getWorkObjectNumber();
    }

    public String getTag() throws VWException {
        return super.getTag();
    }

    public String getWorkClassName() throws VWException {
        return super.getWorkClassName();
    }

    public String getWorkPerformerClassName() throws VWException {
        return super.getWorkPerformerClassName();
    }

    public String getOperationName() throws VWException {
        return super.getOperationName();
    }

    public String getStepName() throws VWException {
        return super.getStepName();
    }

    public String getAuthoredStepName() throws VWException {
        return super.getAuthoredStepName();
    }

    public String toString() {
        String name = null;
        try {
            name = this.getWorkObjectName();
        }
        catch (VWException vWException) {
            // empty catch block
        }
        return name;
    }

    public void doAbort() throws VWException {
        int saveType = 0;
        boolean isExceptionMap = this.getIsExceptionMap();
        VWException[] results = VWWorkObject.unlockSave(new VWWorkObject[]{this}, saveType, false, null, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, true, false);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public void doDispatch() throws VWException {
        int saveType = 1;
        boolean isExceptionMap = this.getIsExceptionMap();
        VWException[] results = VWWorkObject.unlockSave(new VWWorkObject[]{this}, saveType, false, null, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, true, true);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public VWProcess getProcess() throws VWException {
        return this.fetchProcess();
    }

    public VWProcess fetchProcess() throws VWException {
        if (this.workFlowId == null) {
            this.workFlowId = this.getWorkFlowNumber();
        }
        VWProcess process = this.fetchProcess(this.getWorkSpaceId(), this.getWorkClassId(), this.workFlowId);
        process.setServiceSession(this.sourceQuery.querySource.serviceSession);
        return process;
    }

    public VWStepElement fetchStepElement() throws VWException {
        VWStepElement resultObject = new VWStepElement(null, this.workObjectId, this.sourceQuery);
        resultObject.fetchFields(5, false, false);
        if (null == resultObject.workObjectId) {
            return null;
        }
        return resultObject;
    }

    public Date getDateReceived() throws VWException {
        Date dateReceived = super.getDateReceived();
        return dateReceived;
    }

    public String getExceptionMap() {
        return super.getExceptionInstructionSheet();
    }

    public VWDataField[] getDataFields(int fieldTypeFlag, int fieldCreatorFlag) throws VWException {
        int fType = 0;
        VWDataField[] dFields = null;
        VWDataField[] dataFields = super.getDataFields();
        int systemField = 1;
        if (dataFields != null && dataFields.length > 0) {
            VWArrayHandler dfHandler = new VWArrayHandler(20, 10);
            for (int i = 0; i < dataFields.length; ++i) {
                fType = dataFields[i].getFieldType();
                systemField = dataFields[i].getIsSystemField() ? 2 : 1;
                if ((fieldCreatorFlag & systemField) != systemField || (fieldTypeFlag & fType) != fType) continue;
                dFields = (VWDataField[])dfHandler.addElementToArray(dFields, dataFields[i]);
            }
            return (VWDataField[])dfHandler.getElements(dFields);
        }
        return new VWDataField[0];
    }

    public VWDataField getDataField(String name) throws VWException {
        return super.getDataField(name);
    }

    public Date getLaunchDate() throws VWException {
        return super.getLaunchDate();
    }

    public String getOriginator() throws VWException {
        return super.getOriginator();
    }

    public VWParticipant getOriginatorPx() throws VWException {
        return super.getOriginatorPx();
    }

    public String getParticipantName() throws VWException {
        return super.getParticipantName();
    }

    public VWParticipant getParticipantNamePx() throws VWException {
        return super.getParticipantNamePx();
    }

    public void doReassign(String participant, boolean delegateFlag, String queueName) throws VWException {
        boolean isExceptionMap = this.getIsExceptionMap();
        super.doReassign(new VWWorkObject[]{this}, 1, null, participant, delegateFlag, queueName, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, 0L);
    }

    public void doReassignByDomain(String theDomainName, String participant, boolean delegateFlag, String queueName) throws VWException {
        boolean isExceptionMap = this.getIsExceptionMap();
        super.doReassign(new VWWorkObject[]{this}, 1, theDomainName, participant, delegateFlag, queueName, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap, 65537L);
    }

    public void doReturnToSource() throws VWException {
        if (!this.getCanReturnToSource()) {
            throw new VWException("vw.api.VWWOInvalidDoReturnToSource", "Can not return to source.");
        }
        boolean isExceptionMap = this.getIsExceptionMap();
        super.doReturn(new VWWorkObject[]{this}, 1, isExceptionMap ? this.getExceptionMap() : this.getCallMap(), isExceptionMap ? this.getExceptionDescription() : null, isExceptionMap);
    }

    public void doSave(boolean unlock) throws VWException {
        boolean isExceptionMap = this.getIsExceptionMap();
        int saveType = 1;
        VWException[] results = null;
        results = isExceptionMap ? VWWorkObject.unlockSave(new VWWorkObject[]{this}, saveType, false, null, unlock ? this.getExceptionMap() : null, unlock ? this.getExceptionDescription() : null, isExceptionMap, unlock, false) : VWWorkObject.unlockSave(new VWWorkObject[]{this}, saveType, false, null, unlock ? this.getCallMap() : null, null, isExceptionMap, unlock, false);
        if (results != null && results[0] instanceof VWException) {
            throw results[0];
        }
    }

    public String getWorkflowName() throws VWException {
        return super.getWorkClassName();
    }

    public String getLockedUser() throws VWException {
        return super.getLockedUser();
    }

    public VWParticipant getLockedUserPx() throws VWException {
        return super.getLockedUserPx();
    }

    public void setDataFields(VWDataField[] dataFields, boolean compareValues) throws VWException {
        if (dataFields == null) {
            throw new VWException("vw.api.WOSetDataFieldsNull", "Data fields parameter is null.");
        }
        if (dataFields != null && dataFields.length > 0) {
            for (int i = 0; i < dataFields.length; ++i) {
                String dataFieldName;
                if (dataFields[i] == null || (dataFieldName = dataFields[i].getName()) == null) continue;
                Object dataFieldValue = dataFields[i].getValue();
                this.setFieldValue(dataFieldName, dataFieldValue, compareValues);
            }
        }
    }

    public boolean getIsTracker() throws VWException {
        return super.getIsTracker();
    }

    public String getRosterName() throws VWException {
        return super.getRosterName();
    }

    public String getWorkFlowNumber() throws VWException {
        return super.getWorkFlowNumber();
    }

    public String getWorkflowNumber() throws VWException {
        return super.getWorkFlowNumber();
    }

    public String[] getTrackers() throws VWException {
        return super.getTrackers();
    }

    public VWParticipant[] getTrackersPx() throws VWException {
        return super.getTrackersPx();
    }

    public int getWorkOrderId() throws VWException {
        return super.getWorkOrderId();
    }

    public Date getDeadline() throws VWException {
        return super.getDeadline();
    }

    public Date getReminder() throws VWException {
        return super.getReminder();
    }

    public int getOverdue() throws VWException {
        return super.getOverdue();
    }

    public int getOperationType() throws VWException {
        return super.getOperationType();
    }

    public String getCurrentQueueName() throws VWException {
        return super.getCurrentQueueName();
    }

    public VWStepProcessorInfo fetchStepProcessorInfo() throws VWException {
        return super.fetchStepProcessorInfo();
    }

    public String getComment() throws VWException {
        String comment = super.getComment();
        return comment;
    }

    public String getSubject() throws VWException {
        return super.getSubject();
    }

    public String getInstructionSheetName() throws VWException {
        return super.getInstructionSheetName();
    }

    public String[] getStepResponses() throws VWException {
        return super.getStepResponses();
    }

    public String getSelectedResponse() throws VWException {
        return super.getSelectedResponse();
    }

    public void setSelectedResponse(String response) throws VWException {
        super.setSelectedResponse(response);
    }

    public String getStepDescription() throws VWException {
        return super.getStepDescription();
    }

    public void setCallMap(String aMapName) throws VWException {
        if (aMapName == null) {
            throw new VWException("vw.api.VWSetCallMapNameNull", "null is not a valid map name.");
        }
        super.setCallMap(aMapName);
    }

    public String getCallMap() {
        return super.getCallMap();
    }

    public VWReturnStackElement[] fetchReturnStackElements() throws VWException {
        return super.fetchReturnStackElements();
    }

    public String getLastErrorNumber() throws VWException {
        return super.getLastErrorNumber();
    }

    public String getLastErrorText() throws VWException {
        return super.getLastErrorText();
    }
}

